/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.usb.UsbHub;
import org.usb4java.javax.AbstractDevice;
import org.usb4java.javax.Port;
import org.usb4java.javax.UsbPorts;

final class Ports
implements UsbPorts<Port, AbstractDevice> {
    private final List<Port> ports = new ArrayList<Port>();
    private final UsbHub hub;

    Ports(UsbHub hub) {
        this.hub = hub;
        this.addPort();
    }

    private Port addPort() {
        byte portNo = (byte)(this.ports.size() + 1);
        Port port = new Port(this.hub, portNo);
        this.ports.add(port);
        return port;
    }

    private Port getFreePort() {
        for (Port port : this.ports) {
            if (port.isUsbDeviceAttached()) continue;
            return port;
        }
        return this.addPort();
    }

    @Override
    public byte getNumberOfPorts() {
        return (byte)this.ports.size();
    }

    @Override
    public List<Port> getUsbPorts() {
        return Collections.unmodifiableList(this.ports);
    }

    @Override
    public Port getUsbPort(byte number) {
        int index = (number & 0xFF) - 1;
        if (index < 0 || index >= this.ports.size()) {
            return null;
        }
        return this.ports.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AbstractDevice> getAttachedUsbDevices() {
        ArrayList<AbstractDevice> devices = new ArrayList<AbstractDevice>();
        List<Port> list = this.ports;
        synchronized (list) {
            for (Port port : this.ports) {
                if (!port.isUsbDeviceAttached()) continue;
                devices.add(port.getUsbDevice());
            }
        }
        return Collections.unmodifiableList(devices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUsbDeviceAttached(AbstractDevice device) {
        List<Port> list = this.ports;
        synchronized (list) {
            Port port;
            Iterator<Port> iterator = this.ports.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!device.equals((port = iterator.next()).getUsbDevice()));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectUsbDevice(AbstractDevice device) {
        List<Port> list = this.ports;
        synchronized (list) {
            Port port = this.getFreePort();
            port.connectUsbDevice(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectUsbDevice(AbstractDevice device) {
        List<Port> list = this.ports;
        synchronized (list) {
            for (Port port : this.ports) {
                if (!device.equals(port.getUsbDevice())) continue;
                port.disconnectUsbDevice();
            }
        }
    }
}

