/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.BosDevCapabilityDescriptor;

public final class BosDescriptor {
    private long bosDescriptorPointer;

    public long getPointer() {
        return this.bosDescriptorPointer;
    }

    public native byte bLength();

    public native byte bDescriptorType();

    public native short wTotalLength();

    public native byte bNumDeviceCaps();

    public native BosDevCapabilityDescriptor[] devCapability();

    public String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("BOS Descriptor:%n  bLength %18d%n  bDescriptorType %10d%n  wTotalLength %13s%n  bNumDeviceCaps %11s%n", this.bLength() & 0xFF, this.bDescriptorType() & 0xFF, this.wTotalLength() & 0xFFFF, this.bNumDeviceCaps() & 0xFF));
        BosDevCapabilityDescriptor[] bosDevCapabilityDescriptorArray = this.devCapability();
        int n = bosDevCapabilityDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            BosDevCapabilityDescriptor descriptor = bosDevCapabilityDescriptorArray[n2];
            builder.append(descriptor.dump().replaceAll("(?m)^", "  "));
            ++n2;
        }
        return builder.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.wTotalLength()).append(this.bNumDeviceCaps()).append((Object[])this.devCapability()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        BosDescriptor other = (BosDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.wTotalLength(), other.wTotalLength()).append(this.bNumDeviceCaps(), other.bNumDeviceCaps()).append((Object[])this.devCapability(), (Object[])other.devCapability()).isEquals();
    }

    public String toString() {
        return this.dump();
    }
}

