/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.DescriptorUtils;
import org.usb4java.Interface;

public final class ConfigDescriptor {
    private long configDescriptorPointer;

    public long getPointer() {
        return this.configDescriptorPointer;
    }

    public native byte bLength();

    public native byte bDescriptorType();

    public native short wTotalLength();

    public native byte bNumInterfaces();

    public native byte bConfigurationValue();

    public native byte iConfiguration();

    public native byte bmAttributes();

    public native byte bMaxPower();

    public native Interface[] iface();

    public native ByteBuffer extra();

    public native int extraLength();

    public String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s  extralen %17d%n  extra:%n%s", DescriptorUtils.dump(this), this.extraLength(), DescriptorUtils.dump(this.extra()).replaceAll("(?m)^", "    ")));
        Interface[] interfaceArray = this.iface();
        int n = interfaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Interface iface = interfaceArray[n2];
            builder.append(String.valueOf(String.format("%n", new Object[0])) + iface.dump());
            ++n2;
        }
        return builder.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.wTotalLength()).append(this.bNumInterfaces()).append(this.bConfigurationValue()).append(this.iConfiguration()).append(this.bmAttributes()).append(this.bMaxPower()).append((Object[])this.iface()).append((Object)this.extra()).append(this.extraLength()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigDescriptor other = (ConfigDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.wTotalLength(), other.wTotalLength()).append(this.bNumInterfaces(), other.bNumInterfaces()).append(this.bConfigurationValue(), other.bConfigurationValue()).append(this.iConfiguration(), other.iConfiguration()).append(this.bmAttributes(), other.bmAttributes()).append(this.bMaxPower(), other.bMaxPower()).append((Object[])this.iface(), (Object[])other.iface()).append((Object)this.extra(), (Object)other.extra()).append(this.extraLength(), other.extraLength()).isEquals();
    }

    public String toString() {
        return this.dump();
    }
}

