/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.DescriptorUtils;
import org.usb4java.EndpointDescriptor;

public final class InterfaceDescriptor {
    private long interfaceDescriptorPointer;

    InterfaceDescriptor() {
    }

    public long getPointer() {
        return this.interfaceDescriptorPointer;
    }

    public native byte bLength();

    public native byte bDescriptorType();

    public native byte bInterfaceNumber();

    public native byte bAlternateSetting();

    public native byte bNumEndpoints();

    public native byte bInterfaceClass();

    public native byte bInterfaceSubClass();

    public native byte bInterfaceProtocol();

    public native byte iInterface();

    public native EndpointDescriptor[] endpoint();

    public native ByteBuffer extra();

    public native int extraLength();

    public String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s  extralen %17d%n  extra:%n%s", DescriptorUtils.dump(this), this.extraLength(), DescriptorUtils.dump(this.extra()).replaceAll("(?m)^", "    ")));
        EndpointDescriptor[] endpointDescriptorArray = this.endpoint();
        int n = endpointDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            EndpointDescriptor epDesc = endpointDescriptorArray[n2];
            builder.append(String.valueOf(String.format("%n", new Object[0])) + epDesc.dump());
            ++n2;
        }
        return builder.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.bLength()).append(this.bDescriptorType()).append(this.bInterfaceNumber()).append(this.bAlternateSetting()).append(this.bNumEndpoints()).append(this.bInterfaceClass()).append(this.bInterfaceSubClass()).append(this.bInterfaceProtocol()).append(this.iInterface()).append((Object[])this.endpoint()).append((Object)this.extra()).append(this.extraLength()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterfaceDescriptor other = (InterfaceDescriptor)obj;
        return new EqualsBuilder().append(this.bLength(), other.bLength()).append(this.bDescriptorType(), other.bDescriptorType()).append(this.bInterfaceNumber(), other.bInterfaceNumber()).append(this.bAlternateSetting(), other.bAlternateSetting()).append(this.bNumEndpoints(), other.bNumEndpoints()).append(this.bInterfaceClass(), other.bInterfaceClass()).append(this.bInterfaceSubClass(), other.bInterfaceSubClass()).append(this.bInterfaceProtocol(), other.bInterfaceProtocol()).append(this.iInterface(), other.iInterface()).append((Object[])this.endpoint(), (Object[])other.endpoint()).append((Object)this.extra(), (Object)other.extra()).append(this.extraLength(), other.extraLength()).isEquals();
    }

    public String toString() {
        return this.dump();
    }
}

